<?php
include("templates/headers/inc.php");

if(!isset($_GET["id"])) {
	header("Location: home.php?error=no_param");
	exit;
}

// Include the JS file
$js_files = array("");

// Metadata informations of this page
$page_slug	= "quiz";

// Get website config
$site_config = $dbh->prepare("SELECT * FROM config WHERE config_name IN ('website_name','website_tagline','ads_code','allow_fb')");
$site_config->execute();

$config_array = array();

while($config = $site_config->fetch(PDO::FETCH_ASSOC)) {
	$config_array[$config["config_name"]] = $config["config_value"];
}

$website_name = $config_array["website_name"];
$website_tagline = $config_array["website_tagline"];
$ads_code = $config_array["ads_code"];
$allow_fb = $config_array["allow_fb"];

$participation_id = $_GET["id"];

// Check if user exists...
$participation_sql = $dbh->prepare("SELECT q.id AS quiz_id, q.title, q.user_id AS quiz_author, p.id, p.created_at AS participation_date, p.percent, p.nb_good, p.nb_wrong, u.id AS participant_id, u.fullname AS participant_name, u.profile_picture
									FROM quiz q, participation p, user u
									WHERE q.id = p.quiz_id
									AND p.user_id = u.id
									AND p.unique_id = :unique_id
									");
					
$participation_sql->bindParam(':unique_id', $participation_id);
$participation_sql->execute();

if($participation_sql->rowCount() == 0) {
	header("Location: home.php?error=participation_not_found");
	exit;
}

$fb_enabled = false;

if(FB_APP_ID != "" && FB_APP_SECRET != "") {

	// Initialize FB SDK
	$fb = new \Facebook\Facebook([
		'app_id' => FB_APP_ID,
		'app_secret' => FB_APP_SECRET,
		'default_graph_version' => 'v2.3'
	]);	
	
	$helper = $fb->getRedirectLoginHelper();
	
	// Get FB Login URL
	$permissions = ['email']; // Optional permissions
	$loginUrl = $helper->getLoginUrl(URL . "/fb-login.php", $permissions);
	
	$fb_enabled = true;

}

$participation = $participation_sql->fetch(); 

$quiz_author = $participation["quiz_author"];

// Get infos about the author of the quiz...
$author_sql = $dbh->prepare("	SELECT *
								FROM user
								WHERE id = :user_id
							");
					
$author_sql->bindParam(':user_id', $quiz_author);
$author_sql->execute();

if($author_sql->rowCount() == 0) {
	header("Location: home.php?error=author_not_found");
	exit;
}

$author = $author_sql->fetch();

$q_id = $participation["quiz_id"];

$page_title = $participation["participant_name"] . ' got ' . $participation["nb_good"] . ' good and ' .$participation["nb_wrong"] . ' wrong answers about '. htmlspecialchars($author["fullname"]);

// -- Include the header template
include("templates/headers/quiz_result_header.php");
?>

<?php
if($ads_code != "") {
?>
<div class="row">
	<div class="col-md-12">
		<?php
		echo $ads_code;
		?>
	</div>
</div>
<?php
}	
?>
					
<div class="row">
	
	<div class="inner-container content quiz-result">
		
		<div class="author_profile_infos">
			<div class="row no-gutters">
				<div class="author_profile_pic col-md-5 col-sm-5">
					
					<img src="<?php echo $author["profile_picture"]; ?>" alt="" />
					<h4>Quiz about <b><?php echo htmlspecialchars($author["fullname"]); ?></b></h4>

				</div>
				<div class="col-md-2 col-sm-2 quiz-sep d-flex align-items-center">
					<div class="sep-icon">
						<i class="fas fa-arrows-alt-h"></i>
					</div>
				</div>
				<div class="author_profile_pic col-md-5 col-sm-5">
					
					<img src="<?php echo $participation["profile_picture"]; ?>" alt="" />
					<h4>Taken by <b><?php echo htmlspecialchars($participation["participant_name"]); ?></b></h4>
					
				</div>
			</div>
			<div class="row">
				<hr />
			</div>
		</div>
		<div class="quiz_container">
					
			<div class="quiz_success_container <?php if($participation["percent"] <= 25) { ?>over_0_to_25<?php } else if($participation["percent"] <= 50) { ?>over_25_to_50<?php } else if($participation["percent"] <= 75) { ?>over_50_to_75<?php } else if($participation["percent"] <= 100) { ?>over_75_to_100<?php } ?>" style="display: block;">
				
				<div class="percent_container">
					<span><?php echo $participation["percent"]; ?><small>%</small></span>
				</div>
				<div class="percent_line">
					<b><?php echo htmlspecialchars($participation["participant_name"]); ?></b> got <b><?php echo $participation["nb_good"]; ?></b> good and <b><?php echo $participation["nb_wrong"]; ?></b> wrong answers about <b><?php echo $author["fullname"]; ?></b>
				</div>
				
			</div>
			
			<div class="quiz_do_like">
				<h4>Do like <b><?php echo $author["fullname"]; ?></b>, create your own quiz in a few seconds :</h4>
				<?php
				if($allow_fb == 1 && $fb_enabled) {
				?>
				<a href="<?php echo $loginUrl; ?>" class="btn-login-fb"><img src="<?php echo URL; ?>/img/fb-login.png" alt="Login with Facebook" /></a>
				<div class="or_separator">
		        	OR
		        </div>
		        <a href="sign-up.php" class="btn btn-primary btn-sign-up">Create an Account with an Email</a>
		        <?php
				}
				?>
			</div>
			
		</div>
		
	</div>
	
</div>

<?php
// -- Include the footer template
include("templates/footers/global_footer.php");	
?>